// CPageSettingLoopItem.cpp : implementation file
//

#include "stdafx.h"
#include "NetDecoder.h"
#include "PageSettingLoopItem.h"

#define STATE_OFFLINE	0
#define STATE_ONLINE	1
#define STATE_CONNECT	2

#define START_LOOP  1
#define STOP_LOOP   0

// CPageSettingLoopItem dialog

IMPLEMENT_DYNAMIC(CPageSettingLoopItem, CDialog)

CPageSettingLoopItem::CPageSettingLoopItem(CWnd* pParent /*=NULL*/)
	:CLS_CBasePage(CPageSettingLoopItem::IDD, pParent)
	, m_iPlanNo(1)
	, m_iHoldTime(30)
	, m_iLoopStatus(STOP_LOOP)
{

}

CPageSettingLoopItem::~CPageSettingLoopItem()
{
}

void CPageSettingLoopItem::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_COMBO_PLAN, m_cboPlanNo);
	DDX_Text(pDX, IDC_EDIT_PLANNO, m_iPlanNo);
	DDV_MinMaxInt(pDX, m_iPlanNo, 1, 16);
	DDX_Text(pDX, IDC_EDIT_PALN_HOLDTIME, m_iHoldTime);
	DDV_MinMaxInt(pDX, m_iHoldTime, 30, 9999);
	DDX_Control(pDX, IDC_LIST_PLAN_LOOP_ITEM, m_lstPlanItem);
}


BEGIN_MESSAGE_MAP(CPageSettingLoopItem, CDialog)
	ON_BN_CLICKED(IDC_BUTTON_PLAN_APPLY, &CPageSettingLoopItem::OnBnClickedButtonPlanApply)
	ON_BN_CLICKED(IDC_BUTTON_PLAN_SAVE, &CPageSettingLoopItem::OnBnClickedButtonPlanSave)
	ON_BN_CLICKED(IDC_BUTTON_PALN_SET, &CPageSettingLoopItem::OnBnClickedButtonPalnSet)
	ON_CBN_SELCHANGE(IDC_COMBO_PLAN, &CPageSettingLoopItem::OnCbnSelchangeComboPlan)
	ON_BN_CLICKED(IDC_CFG_PLANLOOPITEMDEL, &CPageSettingLoopItem::OnBnClickedCfgPlanloopitemdel)
	ON_BN_CLICKED(IDC_CFG_PLANLOOPITEM_SET, &CPageSettingLoopItem::OnBnClickedCfgPlanloopitemSet)
	ON_BN_CLICKED(IDC_CFG_PLANLOOPITEM_ADD, &CPageSettingLoopItem::OnBnClickedCfgPlanloopitemAdd)
	ON_NOTIFY(NM_CLICK, IDC_LIST_PLAN_LOOP_ITEM, &CPageSettingLoopItem::OnNMClickListPlanLoopItem)
	ON_BN_CLICKED(IDC_BUTTON_LOOP, &CPageSettingLoopItem::OnBnClickedButtonLoop)
END_MESSAGE_MAP()


// CPageSettingLoopItem message handlers

BOOL CPageSettingLoopItem::OnInitDialog()
{
	CLS_CBasePage::OnInitDialog();

	// TODO:  Add extra initialization here
	int iIndexSysPos = -1;
	for (int i = 1; i <= MAX_PLAN_COUNT; i++)
	{
		CString szTemp;
		szTemp.Format("%d", i);
		iIndexSysPos = m_cboPlanNo.AddString(szTemp);
		m_cboPlanNo.SetItemData(iIndexSysPos, i - 1);
	}

	m_cboPlanNo.SetCurSel(0);

	m_lstImg.Create(16,16,ILC_COLOR32,3,3);
	m_lstImg.SetBkColor(RGB(255,255,255));
	HICON hIcon=AfxGetApp()->LoadIcon(IDI_OFFLINE);
	m_lstImg.Add(hIcon);
	hIcon=AfxGetApp()->LoadIcon(IDI_ONLINE);
	m_lstImg.Add(hIcon);

	m_lstPlanItem.SetExtendedStyle(m_lstPlanItem.GetExtendedStyle() | LVS_SHOWSELALWAYS);

	int iSubItem = 0;
	m_lstPlanItem.SetImageList(&m_lstImg,LVSIL_SMALL);
	m_lstPlanItem.SetExtendedStyle(LVS_EX_GRIDLINES|LVS_EX_FULLROWSELECT);

	InsertColumn(m_lstPlanItem,0,GetTextByLan("л","No."),LVCFMT_LEFT,60);
	InsertColumn(m_lstPlanItem,1,GetTextByLan("Ԥ","PlanNo"),LVCFMT_LEFT,80);
	InsertColumn(m_lstPlanItem,2,GetTextByLan("ͣʱ","HoldTime"),LVCFMT_LEFT,80);
	InsertColumn(m_lstPlanItem,3,GetTextByLan("Ԥ","Alias"),LVCFMT_LEFT,80);

	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}
void CPageSettingLoopItem::OnParamChangeNotify(_CHANGE_PARAM_NOTIFY_DATA* _pData)
{
	if(NULL == _pData)
		return;
	switch(_pData->m_iMsg)
	{
	case DEC_PARACHANGE_PLAN_LOOP_ITEM_LIST:
		{
			UpdatePlanLoopItem();
		}
		break;
	case DEC_PARACHANGE_STARTPLANLOOP:
	case DEC_PARACHANGE_STOPPLANLOOP:
		UpdateLoopStatus(_pData->tParam.tPlanLoopStatus.iStatus);
		break;

	case DEC_PARACHANGE_PLAN_LOOP:
		{
			UpdateLoop(_pData->tParam.tPlanLoop);
		}
		break;
	default:
		break;
	}
}
void CPageSettingLoopItem::Initialize()
{
	SetDlgItemText(IDC_STATIC_GROUP_LOOPITEM,GetTextByLan("Ԥ","Loop Item"));
	SetDlgItemText(IDC_STATIC_PLANNO,GetTextByLan("","No"));
	SetDlgItemText(IDC_STATIC_OTHERNAME,GetTextByLan("","Other Name"));
	SetDlgItemText(IDC_STATIC_MODIFYTIME,GetTextByLan("޸ʱ","Modify Name"));
	SetDlgItemText(IDC_BUTTON_PLAN_APPLY,GetTextByLan("Ӧ","Apply"));
	SetDlgItemText(IDC_BUTTON_PLAN_SAVE,GetTextByLan("Ԥ","Loop Item"));
	SetDlgItemText(IDC_BUTTON_PALN_SET,GetTextByLan("ñ","Set Name"));

	SetDlgItemText(IDC_STATIC_PLANLOOPITEM,GetTextByLan("Ԥл","Plan Loop Item"));
	SetDlgItemText(IDC_STATIC_PLANLOOPITEMNO,GetTextByLan("Ԥ","PlanNo"));
	SetDlgItemText(IDC_STATIC_HOLDTIME,GetTextByLan("ͣʱ","Hold Time"));
	SetDlgItemText(IDC_CFG_PLANLOOPITEMDEL,GetTextByLan("ɾ","Delete"));
	SetDlgItemText(IDC_CFG_PLANLOOPITEM_SET,GetTextByLan("޸","Modify"));
	SetDlgItemText(IDC_CFG_PLANLOOPITEM_ADD,GetTextByLan("","Add"));


	UpdatePlanNo();
	UpdatePlanInfo();
	UpdatePlanLoopItem();
	UpdatePlanLoop();
}

void CPageSettingLoopItem::UpdatePlanLoop()
{
	PlanLoop tPlanLoop = {0};
	int iRet = DEC_ClientGetDevConfig(m_lLogonID,0,0,CMD_DEC_CFG_PLANLOOP,&tPlanLoop,sizeof(PlanLoop));
	if(iRet < ERR_SUCCESS)
	{
		AddLog(LOG_LEVEL_ERROR,"[CPageSettingLoopItem::UpdatePlanLoop] DEC_ClientGetDevConfig CMD_DEC_CFG_PLANLOOP \
							   failed!Ret(%d),Error(0x%08x),ID(%d)", iRet, GetLastError(), m_lLogonID);
		return;
	}
	if(START_LOOP == tPlanLoop.iEnable)
	{
		UpdateLoopStatus(LOOP_STATUS_START);
	}else{
		UpdateLoopStatus(LOOP_STATUS_STOP);
	}
	m_iLoopStatus = tPlanLoop.iEnable;
}

void CPageSettingLoopItem::UpdatePlanNo()
{
	ApplyPlan tApply = {0};
	tApply.iSize = sizeof(ApplyPlan);
	int iRet = DEC_ClientGetDevConfig(m_lLogonID, 0, 0, CMD_DEC_CFG_APPLY_PLAN, &tApply, tApply.iSize);
	if (iRet < ERR_SUCCESS)
	{
		AddLog(LOG_LEVEL_ERROR,"[CPageSettingLoopItem::UpdatePlanNo] DEC_ClientGetDevConfig CMD_DEC_CFG_APPLY_PLAN \
							   failed!Ret(%d),Error(0x%08x),ID(%d)", iRet, GetLastError(), m_lLogonID);
		return;
	}
	m_cboPlanNo.SetCurSel(tApply.iPlanId);
}


void CPageSettingLoopItem::UpdatePlanInfo()
{

	PlanAlias tAlias = {0};
	tAlias.iSize = sizeof(PlanAlias);
	tAlias.iPlanId = GetComboData(&m_cboPlanNo);
	int iRet = DEC_ClientGetDevConfig(m_lLogonID, 0, 0, CMD_DEC_CFG_PLANALIAS, &tAlias, tAlias.iSize);
	if (iRet < ERR_SUCCESS)
	{
		AddLog(LOG_LEVEL_ERROR,"[CPageSettingLoopItem::UpdatePlanNo] DEC_ClientGetDevConfig CMD_DEC_CFG_PLANALIAS \
			failed!Ret(%d),Error(0x%08x),ID(%d)", iRet, GetLastError(), m_lLogonID);
		return;
	}

	DecPlan tPlan = {0};
	tPlan.iSize = sizeof(DecPlan);
	tPlan.iPlanId = GetComboData(&m_cboPlanNo);
	iRet = DEC_ClientGetDevConfig(m_lLogonID, 0, 0, CMD_DEC_CFG_SAVE_PLAN, &tPlan, tPlan.iSize);
	if (iRet < ERR_SUCCESS)
	{
		AddLog(LOG_LEVEL_ERROR,"[CPageSettingLoopItem::UpdatePlanNo] DEC_ClientGetDevConfig CMD_DEC_CFG_SAVE_PLAN \
							   failed!Ret(%d),Error(0x%08x),ID(%d)", iRet, GetLastError(), m_lLogonID);
		return;
	}
	SetDlgItemText(IDC_EDIT_PLAN_ALIAS, tAlias.cAlias);
	SetDlgItemText(IDC_EDIT_PLAN_TIME, tPlan.cSaveTime);	

}

void CPageSettingLoopItem::OnBnClickedButtonPlanApply()
{
	// TODO: Add your control notification handler code here
	if (m_lLogonID < 0)
	{
		return;
	}
	ApplyPlan tApply = {0};
	tApply.iSize = sizeof(ApplyPlan);
	tApply.iPlanId = GetComboData(&m_cboPlanNo);
	int iRet = DEC_ClientSetDevConfig(m_lLogonID, 0, 0, CMD_DEC_CFG_APPLY_PLAN, &tApply, tApply.iSize);
	if (iRet < ERR_SUCCESS)
	{
		AddLog(LOG_LEVEL_ERROR,"[CPageSettingLoopItem::OnBnClickedButtonPlanApply] DEC_ClientSetDevConfig CMD_DEC_CFG_APPLY_PLAN \
							   failed!Ret(%d),Error(0x%08x),ID(%d)", iRet, GetLastError(), m_lLogonID);
		return;
	}
}

void CPageSettingLoopItem::OnBnClickedButtonPlanSave()
{
	// TODO: Add your control notification handler code here
	DecPlan tPlan = {0};
	tPlan.iSize = sizeof(DecPlan);
	tPlan.iPlanId = GetComboData(&m_cboPlanNo);
	int iRet = DEC_ClientSetDevConfig(m_lLogonID, 0, 0, CMD_DEC_CFG_SAVE_PLAN, &tPlan, tPlan.iSize);
	if (iRet < ERR_SUCCESS)
	{
		AddLog(LOG_LEVEL_ERROR,"[CPageSettingLoopItem::OnBnClickedButtonPlanSave] DEC_ClientSetDevConfig CMD_DEC_CFG_SAVE_PLAN \
							   failed!Ret(%d),Error(0x%08x),ID(%d)", iRet, GetLastError(), m_lLogonID);
		return;
	}
}

void CPageSettingLoopItem::OnBnClickedButtonPalnSet()
{
	// TODO: Add your control notification handler code here
	PlanAlias tAlias = {0};
	tAlias.iSize = sizeof(PlanAlias);
	tAlias.iPlanId = GetComboData(&m_cboPlanNo);
	CString strAlias;
	GetDlgItemText(IDC_EDIT_PLAN_ALIAS, strAlias);
	strncpy(tAlias.cAlias, strAlias.GetBuffer(), sizeof(tAlias.cAlias) - 1);
	int iRet = DEC_ClientSetDevConfig(m_lLogonID, 0, 0, CMD_DEC_CFG_PLANALIAS, &tAlias, tAlias.iSize);
	if (iRet < ERR_SUCCESS)
	{
		AddLog(LOG_LEVEL_ERROR,"[CPageSettingLoopItem::OnBnClickedButtonPalnSet] DEC_ClientSetDevConfig CMD_DEC_CFG_PLANALIAS \
							   failed!Ret(%d),Error(0x%08x),ID(%d)", iRet, GetLastError(), m_lLogonID);
		return;
	}
}

void CPageSettingLoopItem::OnCbnSelchangeComboPlan()
{
	// TODO: Add your control notification handler code here
	if (m_lLogonID < 0)
	{
		return;
	}

	UpdatePlanInfo();
}
void CPageSettingLoopItem::UpdatePlanLoopItem()
{
	PlanLoopList tPlanLoopList = {0};

	int iRet = DEC_ClientGetDevConfig(m_lLogonID,0,0,CMD_DEC_CFG_PLANLOOPITEM,&tPlanLoopList,sizeof(PlanLoopList));
	if(iRet < ERR_SUCCESS)
	{
		AddLog(LOG_LEVEL_ERROR,"[CPageSettingLoopItem::UpdatePlanLoopItem] DEC_ClientGetDevConfig CMD_DEC_CFG_PLANLOOPITEM \
							   failed!Ret(%d),Error(0x%08x),ID(%d)", iRet, GetLastError(), m_lLogonID);
		return;
	}
	
	m_lstPlanItem.DeleteAllItems();

	for (int i = 0; i < tPlanLoopList.iCount && i < DEC_MAX_PLAN_LOOP_ITEM_NUM ; i++)
	{
		CString szTemp;
		szTemp.Format("%d", i);
		m_lstPlanItem.InsertItem(i,szTemp,STATE_OFFLINE);
		szTemp.Format("%d", tPlanLoopList.tPlanLoopItem[i].iPlanNo+1);
		m_lstPlanItem.SetItemText(i,1,szTemp);
		szTemp.Format("%d", tPlanLoopList.tPlanLoopItem[i].iHoldTime);
		m_lstPlanItem.SetItemText(i,2,szTemp);

		PlanAlias tAlias = {0};
		tAlias.iSize = sizeof(PlanAlias);
		tAlias.iPlanId = tPlanLoopList.tPlanLoopItem[i].iPlanNo;
		DEC_ClientGetDevConfig(m_lLogonID, 0, 0, CMD_DEC_CFG_PLANALIAS, &tAlias, tAlias.iSize);
		m_lstPlanItem.SetItemText(i,3,tAlias.cAlias);

	}
	UpdateData(FALSE);

}
void CPageSettingLoopItem::OnBnClickedCfgPlanloopitemdel()
{
	// TODO: Add your control notification handler code here
	POSITION pos = m_lstPlanItem.GetFirstSelectedItemPosition();
	if (pos)
	{
		int iItem = m_lstPlanItem.GetNextSelectedItem(pos);
		if (iItem >= 0)
		{
			PlanLoopItemDel tPlanLoopItemDel = {0};
			tPlanLoopItemDel.iIndex = iItem;

			int iRet = DEC_ClientSetDevConfig(m_lLogonID,0,0,CMD_DEC_CFG_PLANLOOPITEMDEL,&tPlanLoopItemDel,sizeof(PlanLoopItemDel));
			if(iRet < ERR_SUCCESS)
			{
				AddLog(LOG_LEVEL_ERROR,"[CPageSettingLoopItem::OnBnClickedCfgPlanloopitemdel] DEC_ClientSetDevConfig CMD_DEC_CFG_PLANLOOPITEMDEL \
									   failed!Ret(%d),Error(0x%08x),ID(%d)", iRet, GetLastError(), m_lLogonID);
				return;
			}
		}
	}
}

void CPageSettingLoopItem::OnBnClickedCfgPlanloopitemSet()
{
	// TODO: Add your control notification handler code here
	
	POSITION pos = m_lstPlanItem.GetFirstSelectedItemPosition();
	if (pos)
	{
		int iItem = m_lstPlanItem.GetNextSelectedItem(pos);
		if (iItem >= 0)
		{
			SetLoopItem(iItem);
		}
	}

	
}

void CPageSettingLoopItem::SetLoopItem(int _iIndex)
{
	UpdateData(TRUE);
	if(m_iPlanNo < 1)
	{
		return;
	}
	PlanLoopItem tPlanLoopItem = {0};
	tPlanLoopItem.iIndex = _iIndex;
	tPlanLoopItem.iPlanNo = m_iPlanNo-1;
	tPlanLoopItem.iHoldTime = m_iHoldTime;
	int iRet = DEC_ClientSetDevConfig(m_lLogonID,0,0,CMD_DEC_CFG_PLANLOOPITEM,&tPlanLoopItem,sizeof(PlanLoopItem));
	if(iRet < ERR_SUCCESS)
	{
		AddLog(LOG_LEVEL_ERROR,"[CPageSettingLoopItem::SetLoopItem] DEC_ClientSetDevConfig CMD_DEC_CFG_PLANLOOPITEM \
							   failed!Ret(%d),Error(0x%08x),ID(%d)", iRet, GetLastError(), m_lLogonID);
		return;
	}
}

void CPageSettingLoopItem::OnBnClickedCfgPlanloopitemAdd()
{
	// TODO: Add your control notification handler code here
	int iCount = m_lstPlanItem.GetItemCount();
	if(iCount < DEC_MAX_PLAN_LOOP_ITEM_NUM)
	{
		SetLoopItem(iCount);
	}
}

void CPageSettingLoopItem::OnNMClickListPlanLoopItem(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMITEMACTIVATE pNMItemActivate = reinterpret_cast<LPNMITEMACTIVATE>(pNMHDR);
	// TODO: Add your control notification handler code here
	int iItem = pNMItemActivate->iItem;
	if (iItem >= 0)
	{
		PlanLoopList tPlanLoopList = {0};

		int iRet = DEC_ClientGetDevConfig(m_lLogonID,0,0,CMD_DEC_CFG_PLANLOOPITEM,&tPlanLoopList,sizeof(PlanLoopList));
		if(iRet < ERR_SUCCESS)
		{
			AddLog(LOG_LEVEL_ERROR,"[CPageSettingLoopItem::OnNMClickListPlanLoopItem] DEC_ClientSetDevConfig CMD_DEC_CFG_PLANLOOPITEM \
								   failed!Ret(%d),Error(0x%08x),ID(%d)", iRet, GetLastError(), m_lLogonID);
			return;
		}
		if(iItem < tPlanLoopList.iCount)
		{
			m_iPlanNo = tPlanLoopList.tPlanLoopItem[iItem].iPlanNo+1;
			m_iHoldTime = tPlanLoopList.tPlanLoopItem[iItem].iHoldTime;
		}
		UpdateData(FALSE);
	
	}
	*pResult = 0;
}

void CPageSettingLoopItem::OnBnClickedButtonLoop()
{
	// TODO: Add your control notification handler code here

	if(STOP_LOOP==m_iLoopStatus)
	{
		LoopParam tPlanLoop = {0};
		tPlanLoop.iType = LOOP_TYPE_PLAN;
		int iRet = DEC_ClientSetDevConfig(m_lLogonID,0,0,CMD_DEC_CFG_START_LOOP,&tPlanLoop,sizeof(LoopParam));
		if(iRet < ERR_SUCCESS)
		{
			AddLog(LOG_LEVEL_ERROR,"[CPageSettingLoopItem::OnBnClickedButtonLoop] DEC_ClientSetDevConfig CMD_DEC_CFG_START_LOOP \
								   failed!Ret(%d),Error(0x%08x),ID(%d)", iRet, GetLastError(), m_lLogonID);
			return;
		}
		InitImage();
		m_iLoopStatus = START_LOOP;
	}
	else if(START_LOOP==m_iLoopStatus)
	{
		LoopParam tPlanLoop = {0};
		tPlanLoop.iType = LOOP_TYPE_PLAN;
		int iRet = DEC_ClientSetDevConfig(m_lLogonID,0,0,CMD_DEC_CFG_STOP_LOOP,&tPlanLoop,sizeof(LoopParam));
		if(iRet < ERR_SUCCESS)
		{
			AddLog(LOG_LEVEL_ERROR,"[CPageSettingLoopItem::OnBnClickedButtonLoop] DEC_ClientSetDevConfig CMD_DEC_CFG_STOP_LOOP \
								   failed!Ret(%d),Error(0x%08x),ID(%d)", iRet, GetLastError(), m_lLogonID);
			return;
		}
		m_iLoopStatus = STOP_LOOP;
	}

}

void CPageSettingLoopItem::InitImage()
{
	for (int i = 0; i < m_lstPlanItem.GetItemCount(); i++)
	{
		LVITEM tItem = {0};
		tItem.mask = LVIF_IMAGE;
		tItem.iItem = i;
		tItem.iImage = STATE_OFFLINE; 
		m_lstPlanItem.SetItem(&tItem);
	}
}

void CPageSettingLoopItem::UpdateLoop(PlanLoop &tPlanLoop)
{
	//m_iLoopStatus = tPlanLoop.iEnable;
	if(START_LOOP == tPlanLoop.iEnable)
	{
	    //UpdateLoopStatus(LOOP_STATUS_START);

		InitImage();
		//бел״̬
		int iCount = m_lstPlanItem.GetItemCount();
		if(iCount > tPlanLoop.iIndex)
		{
			LVITEM tItem = {0};
			tItem.mask = LVIF_IMAGE;
			tItem.iItem = tPlanLoop.iIndex;
			tItem.iImage = STATE_ONLINE; 
			m_lstPlanItem.SetItem(&tItem);
		}

	}else{
		//UpdateLoopStatus(LOOP_STATUS_STOP);
	}
}

void CPageSettingLoopItem::UpdateLoopStatus(int  iStatus)
{
	if(LOOP_STATUS_START==iStatus)
	{
		SetDlgItemText(IDC_BUTTON_LOOP,GetTextByLan("ֹͣл","Stop Loop"));
		GetDlgItem(IDC_CFG_PLANLOOPITEM_ADD)->EnableWindow(FALSE);
		GetDlgItem(IDC_CFG_PLANLOOPITEM_SET)->EnableWindow(FALSE);
		GetDlgItem(IDC_CFG_PLANLOOPITEMDEL)->EnableWindow(FALSE);
	}else if(LOOP_STATUS_STOP==iStatus)
	{
		SetDlgItemText(IDC_BUTTON_LOOP,GetTextByLan("ʼл","Start Loop"));
		GetDlgItem(IDC_CFG_PLANLOOPITEM_ADD)->EnableWindow(TRUE);
		GetDlgItem(IDC_CFG_PLANLOOPITEM_SET)->EnableWindow(TRUE);
		GetDlgItem(IDC_CFG_PLANLOOPITEMDEL)->EnableWindow(TRUE);
	}
}

